statemachine class SpellsEnergyArea extends CGameplayEntity 
{	
	var i,z 										: int;
	var entities_trap								: array< CGameplayEntity >;
	var active										: bool;
	var player_inside								: bool;
	var effects, sword_effects						: array< CEntity >;
	var damage_action 								: W3DamageAction;
	var victims 									: array< CActor >;
	var bonenames									: array< name >;
	var abs_to_block								: array< name >;
	var add_eff										: CEntity;
	var rot 										: EulerAngles;
	var effect_sword								: CEntity;
	var vector_sword								: Vector;
	var euler_sword									: EulerAngles;
	var steelcomp, silvercomp, scabbardscomp 		: CDrawableComponent;
	var xbow, swordsteel, swordsilver, effect 		: CEntity;
	var steelid,silverid, xid						: SItemUniqueId;
	var n											: float;
	var quen_hack									: bool;

	event OnSpawned( spawnData : SEntitySpawnData )
	{
		bonenames.Clear();
		bonenames.PushBack( 'head' );	
		bonenames.PushBack( 'l_foot' );	
		bonenames.PushBack( 'r_foot' );	
		bonenames.PushBack( 'r_bicep2' );	
		bonenames.PushBack( 'l_bicep2' );	
		bonenames.PushBack( 'r_forearm' );	
		bonenames.PushBack( 'l_forearm' );	
		bonenames.PushBack( 'r_kneeRoll' );	
		bonenames.PushBack( 'l_kneeRoll' );	
		
		abs_to_block.Clear();
		abs_to_block.PushBack( 'Swarm' );	
		abs_to_block.PushBack( 'SwarmShield' );	
		abs_to_block.PushBack( 'SwarmTeleport' );	
		abs_to_block.PushBack( 'Shapeshifter' );	
		abs_to_block.PushBack( 'ShadowForm' );	
		abs_to_block.PushBack( 'MistForm' );	
		abs_to_block.PushBack( 'MistCharge' );	
		abs_to_block.PushBack( 'Flashstep' );	
		abs_to_block.PushBack( 'FullMoon' );	
		abs_to_block.PushBack( 'EssenceRegen' );	
		abs_to_block.PushBack( 'Teleport' );	
		abs_to_block.PushBack( 'SpawnArena' );	
		abs_to_block.PushBack( 'Magical' );	
	
		PlayEffect('energy_circle');
		active = true;
		AddTimer( 'check_area', 0.1, true );
		create_body_electric_effects();
		create_sword_electric_effects();
		player_inside = false;
		
		rot = GetWorldRotation();
		rot.Yaw -= 180;
		add_eff = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( 'spells_energy_effects'), GetWorldPosition(), rot );
		add_eff.PlayEffect('energy_circle_add');
		
		SoundEvent("ep2_setskill_gryphon_yrden_powerup_LP");
		SoundEvent("ep2_setskill_gryphon_yrden_powerup_LP");
		
		//GetMagicVigil().set_hit_received( false );
		quen_hack = false;
	}
	
	timer function destroy_energy_area(deltaTime : float, id : int) 
	{
		active = false;
		player_inside = false;
		enable_body_electric_effects(false);
		StopAllEffects();
		RemoveTimer('check_area');
		DestroyAfter(3);
		
		for ( i = 0; i <= effects.Size(); i+=1 )
		{
			effects[i].StopAllEffects();
			effects[i].DestroyAfter(3);
		}
		
		block_abs( true );
		
		add_eff.StopAllEffects();
		add_eff.DestroyAfter(3);
		
		for ( i = 0; i <= sword_effects.Size(); i+=1 )
		{
			sword_effects[i].StopAllEffects();
			sword_effects[i].DestroyAfter(3);
		}
		
		SoundEvent("ep2_setskill_gryphon_yrden_powerup_LP_stop");
	}
	
	timer function check_area(deltaTime : float, id : int) 
	{
		var actor 			: CActor;
	
		if ( VecDistance( thePlayer.GetWorldPosition(), this.GetWorldPosition() ) <= 4 )
		{
			if ( !player_inside ) 
			{
				player_inside = true;
				enable_body_electric_effects(true);
			}
		}
		else
		{
			if ( player_inside ) 
			{
				player_inside = false;
				enable_body_electric_effects(false);
			}
		}
		
		FindGameplayEntitiesInRange(entities_trap, this, 20, 100 );
		for ( i = 0; i <= entities_trap.Size(); i+=1 )
		{
			actor = (CActor)entities_trap[i];
			if ( !victims.Contains(actor) )
			{
				victims.PushBack(actor);
			}
			
			if (VecDistance( actor.GetWorldPosition(), this.GetWorldPosition() ) <= 4 )
			{
				if ( !actor.HasTag('spells_blocked_abs') )
				{
					actor.AddTag('spells_to_block_abs');
				}
			}
			else
			{
				if ( actor.HasTag('spells_blocked_abs') )
				{
					actor.AddTag('spells_to_unblock_abs');
				}
			}
		}
		block_abs();
	}
	
	function block_abs( optional force_disable : bool )
	{
		for ( i = 0; i <= victims.Size(); i+=1 )
		{
			if ( victims[i] != thePlayer )
			{
				if ( force_disable )
				{
					if ( victims[i].HasTag('spells_blocked_abs') )
					{
						for ( z = 0; z <= abs_to_block.Size(); z+=1 )
						{
							victims[i].BlockAbility(abs_to_block[z], false);
						}
						
						victims[i].RemoveTag('spells_blocked_abs');
						victims[i].RemoveTag('spells_to_unblock_abs');
						victims[i].RemoveTag('spells_to_block_abs');
					}
				}
				else
				{
					if ( victims[i].HasTag('spells_to_block_abs') )
					{
						for ( z = 0; z <= abs_to_block.Size(); z+=1 )
						{
							victims[i].BlockAbility(abs_to_block[z], true);
						}
						
						victims[i].AddTag('spells_blocked_abs');
						victims[i].RemoveTag('spells_to_block_abs');
					}
					
					if ( victims[i].HasTag('spells_to_unblock_abs')  )
					{
						for ( z = 0; z <= abs_to_block.Size(); z+=1 )
						{
							victims[i].BlockAbility(abs_to_block[z], false);
						}
						
						victims[i].RemoveTag('spells_blocked_abs');
						victims[i].RemoveTag('spells_to_unblock_abs');
					}
				}
			}
		}
	}
	
	
	function enable_body_electric_effects ( enable : bool )
	{
		if ( enable )
		{
			clear_guarding_buffs( false );	
			SoundEvent("magic_geralt_healing_oneshot");
			thePlayer.EnableCharacterCollisions(false);
			thePlayer.PlayEffectSingle('invisible');
			AddTimer('reapply_sword_effect', 0.1, true);
			
			GetMagicVigil().set_inside_energy( true );
			
		}
		else
		{
			RemoveTimer('reapply_sword_effect');
			RemoveTimer('reapply_effect_inv');
		
			for ( i = 0; i <= effects.Size(); i+=1 )
			{
				effects[i].StopAllEffects();
			}
			
			sword_effect( true );
			if ( !thePlayer.HasBuff( EET_Invisibilityspell ) )
			{	thePlayer.DestroyEffect('invisible');	}
			thePlayer.EnableCharacterCollisions(true);
			
			GetMagicVigil().set_inside_energy( false );
		}
	}
	
	timer function reapply_sword_effect(deltaTime : float, id : int) 
	{
		sword_effect();
		
		if ( !thePlayer.HasBuff( EET_Energyshield ) )
		{
			for ( i = 0; i <= effects.Size(); i+=1 )
			{
				effects[i].PlayEffectSingle('electricity');
			}
		}
		else
		{
			for ( i = 0; i <= effects.Size(); i+=1 )
			{
				effects[i].StopAllEffects();
			}
		}
		
		if ( !thePlayer.IsEffectActive('invisible') )
		{
			thePlayer.DestroyEffect('invisible');
			thePlayer.PlayEffectSingle('invisible');
		}
		
		if ( guarding_buffs() || GetWitcherPlayer().IsAnyQuenActive() )
		{
			clear_guarding_buffs( false );	
			AddTimer('reapply_effect_inv',0.5);
		}
		if ( FactsQuerySum( "should_reapply_energy_trap_spells" ) > 0 )
		{
			FactsRemove( "should_reapply_energy_trap_spells" );
			AddTimer('reapply_effect_inv',0.5);
		}
		
	}
	timer function reapply_effect_inv(deltaTime : float, id : int) 
	{
		thePlayer.DestroyEffect('invisible');
		thePlayer.PlayEffectSingle('invisible');
	}
	
	function sword_effect( optional force_off : bool ) 
	{
		thePlayer.GetInventory().GetItemEquippedOnSlot( EES_SteelSword,  steelid  );
		thePlayer.GetInventory().GetItemEquippedOnSlot( EES_SilverSword, silverid );
	
		if ( force_off )
		{
			for ( i = 0; i <= sword_effects.Size(); i+=1 )
			{
				sword_effects[i].StopAllEffects();
			}
		}
		else
		if ( thePlayer.GetInventory().IsItemHeld( steelid ) || thePlayer.GetInventory().IsItemHeld( silverid ) )
		{
			for ( i = 0; i <= sword_effects.Size(); i+=1 )
			{
				sword_effects[i].PlayEffectSingle( 'electricity' );
			}
		}
		else
		{
			for ( i = 0; i <= sword_effects.Size(); i+=1 )
			{
				sword_effects[i].StopAllEffects();
			}
		}
	}
	
	function create_body_electric_effects()
	{
		var effect 			: CEntity;
		
		effect = thePlayer.CreateFXEntityAtBone( 'spells_body_electricity', 'torso', true );
		effects.PushBack(effect);
		
		for( i = 0; i < bonenames.Size(); i += 1 )
		{
			effect = thePlayer.CreateFXEntityAtBone( 'spells_body_glow', bonenames[i], true );
			effects.PushBack(effect);
		}
	}
	
	function create_sword_electric_effects()
	{
		effect_sword = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\energy_sword_glow.w2ent", true), GetWorldPosition() );
		effect_sword.CreateAttachment( thePlayer, 'r_weapon' , Vector( 0, 0, 0.5 ) );
		sword_effects.PushBack(effect_sword);
		
		effect_sword = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\energy_sword_glow.w2ent", true), GetWorldPosition() );
		effect_sword.CreateAttachment( thePlayer, 'r_weapon' , Vector( 0, 0, -0.5 ) );
		sword_effects.PushBack(effect_sword);
		
		euler_sword.Roll = -90; euler_sword.Pitch = 0; euler_sword.Yaw = -90; 
		for( n = -0.7; n <= 0.9f; n += 0.2 )
		//for( n = 0.3; n <= 1.f; n += 0.2 )
		{	
			effect_sword = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( 'spells_energy_sword'), GetWorldPosition(), GetWorldRotation() );
			effect_sword.CreateAttachment( thePlayer, 'r_weapon', Vector( 0.03, 0, 1*n ), euler_sword );
			sword_effects.PushBack(effect_sword);
			
			if ( n == 0.9 )
			{
				effect_sword.AddTag('energy_circle_lightning_sword');
			}
		}
		
		euler_sword.Roll = 90; euler_sword.Pitch = 0; euler_sword.Yaw = -90; 
		for( n = -0.55; n <= 0.7f; n += 0.2 )
		//for( n = 0.15; n <= 0.8f; n += 0.2 )
		{	
			effect_sword = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( 'spells_energy_sword'), GetWorldPosition(), GetWorldRotation() );
			effect_sword.CreateAttachment( thePlayer, 'r_weapon' , Vector( 0.06, 0, 1*n ), euler_sword );
			sword_effects.PushBack(effect_sword);
		}
	}
}


statemachine class SpellsPoisonArea extends CGameplayEntity 
{	
	var i 						: int;
	var entities_trap			: array< CGameplayEntity >;

	event OnSpawned( spawnData : SEntitySpawnData )
	{
		PlayEffect('toxic_gas');
		AddTimer('deal_damage_swamp_area',0.1, true);
		AddTimer('playeffect',1.2, true);
	}
	
	timer function playeffect(deltaTime : float, id : int) 
	{
		PlayEffect('toxic_gas1');
	}
	
	timer function destroy_poison_area(deltaTime : float, id : int) 
	{
		RemoveTimer('playeffect');
		RemoveTimer('deal_damage_swamp_area');
		StopAllEffects();
		DestroyAfter(7);
	}
	
	timer function deal_damage_swamp_area(deltaTime : float, id : int) 
	{
		var victim 				: CActor;
		var damage_action 		: W3DamageAction;
		var damage_value 		: float;
		var heal 				: float;
		
		FindGameplayEntitiesInSphere(entities_trap, GetWorldPosition(), 2.6, 100 );
		
		for ( i = 0; i <= entities_trap.Size(); i+=1 )
		{
			victim = (CActor)entities_trap[i];
			
			if ( !victim.HasBuff(EET_Poison) && victim != thePlayer )
			{
				damage_action =  new W3DamageAction in this;
				damage_action.Initialize( thePlayer, victim, this, thePlayer.GetName()+"_sign", EHRT_None, CPS_Undefined, false, false, true, false);
				damage_action.SetProcessBuffsIfNoDamage(true);
				damage_action.SetHitEffect('');
				damage_action.SetHitEffect('', true );
				damage_action.SetHitEffect('', false, true);
				damage_action.SetHitEffect('', true, true);
			
				damage_action.AddEffectInfo( EET_Poison, 1 );
				theGame.damageMgr.ProcessAction( damage_action );
				delete damage_action;
			}
		}
	}
}

statemachine class W3GreatSwampTrap extends CGameplayEntity 
{	
	var i 																		: int;
	var victims 																: array< CActor >;
	var fxEntities                                                              : array< CEntity >;
	var spellpower_final														: float;
	var aard_hit_ents															: array< CEntity >;
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		AddTimer('check_for_targets_swamp_trap',0.1, true);
		AddTimer('deal_damage_swamp_trap',0.1, true);
		PlayEffect('ignition');
		
		spellpower_final = 0;
	}
	
    timer function destroy_swamp_trap(deltaTime : float, id : int) 
	{
		StopAllEffects();
		DestroyAfter(3);
		RemoveTimer('check_for_targets_swamp_trap');
		RemoveTimer('deal_damage_swamp_trap');
		
		if ( fxEntities.Size() >0 )
		{
			for ( i = 0; i <= fxEntities.Size(); i+=1 )
			{
				fxEntities[i].StopAllEffects();
				fxEntities[i].DestroyAfter(2);
			}
		}
	}
	
	event OnDestroyed()
	{
	}

	timer function check_for_targets_swamp_trap(deltaTime : float, id : int) 
	{
		var entities_trap		: array< CGameplayEntity >;
		var victim 				: CActor;
		var fxEntity			: CEntity;
		
		if ( spellpower_final <=0 )
		{
			if ( HasTag('spells_from_sign') )
			{
				spellpower_final = GetMagicVigil().get_magic_spellpower();
			}
			else
			{
				spellpower_final = get_spellpower_spells( true );
			}
		}
		
		FindGameplayEntitiesInRange(entities_trap, this, 5, 100 );
		
		if( entities_trap.Size()>0 )
		{
			for ( i = 0; i <= entities_trap.Size(); i+=1 )
			{
				victim = (CActor)entities_trap[i];
				
				if ( VecDistance( entities_trap[i].GetWorldPosition(), this.GetWorldPosition() ) <= 2.7 )
				{
					if ( victim && victim.IsAlive() && victim.GetDistanceFromGround( 2 ) < 1.5f && IsRequiredAttitudeBetween(thePlayer, victim, true, false, false) )
					{
						if ( !victims.Contains( victim ) )
						{
							victims.PushBack( victim );
							fxEntity = victim.CreateFXEntityAtPelvis( 'great_swamp_effects', true );
							fxEntity.PlayEffect( 'greatswamp_burning' );
							fxEntities.PushBack(fxEntity);
						}
					}
				}
				
				if ( victim && ( victim.GetDistanceFromGround( 2 ) > 1.5f || VecDistance( victim.GetWorldPosition(), this.GetWorldPosition() ) > 2.7 ) )
				{
					victims.Remove( victim );
				}
			}
		}
		
		if ( fxEntities.Size() >0 )
		{
			for ( i = 0; i <= fxEntities.Size(); i+=1 )
			{
				if ( VecDistance( fxEntities[i].GetWorldPosition(), this.GetWorldPosition() ) > 2.7  )
				{
					fxEntities[i].StopAllEffects();
					fxEntities[i].DestroyAfter(2);
				}
			}
		}
	}
	
	timer function deal_damage_swamp_trap(deltaTime : float, id : int) 
	{
		var victim 				: CActor;
		var damage_action 		: W3DamageAction;
		var damage_value 		: float;
		var heal 				: float;
		
		if( victims.Size() >0 )
		{
			for ( i = 0; i <= victims.Size(); i+=1 )
			{
				victim = (CActor)victims[i];
				
				damage_value = get_damage_value_for_trap( victim, spellpower_final );
				if ( !HasTag('spells_from_sign') )
				{
					damage_value += damage_value * get_manual_aiming_dmg_mod();	  
				}
				damage_value *= deltaTime;
				
				damage_action =  new W3DamageAction in this;
				damage_action.Initialize( thePlayer, victim, this, thePlayer.GetName()+"_sign", EHRT_None, CPS_Undefined, false, false, true, false);
				damage_action.SetIsDoTDamage( deltaTime );
				
				damage_action.AddDamage(theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() * damage_value * 0.6 );
				damage_action.AddDamage(theGame.params.DAMAGE_NAME_POISON, sp_pois_dmg_mod() * damage_value * 0.6 );
				damage_action.SetHitAnimationPlayType(EAHA_ForceNo);
				damage_action.SetProcessBuffsIfNoDamage(true);
				damage_action.SetHitEffect('');
				damage_action.SetHitEffect('', true );
				damage_action.SetHitEffect('', false, true);
				damage_action.SetHitEffect('', true, true);
				theGame.damageMgr.ProcessAction( damage_action );
				
				if ( ( (CNewNPC)victim ).IsShielded( thePlayer ) )
				{
					if ( ( (CNewNPC)victim ).GetBehaviorVariable( 'bShieldUp' ) == 0.f )
					{
						( (CNewNPC)victim ).SetBehaviorVariable( 'bShieldUp', 1.f );
					}
					
					if ( ( (CNewNPC)victim ).GetStaminaPercents() > 0.1 )
					{
						( (CNewNPC)victim ).DrainStamina(ESAT_FixedValue, 5 );
					}
					else 
					{
						( (CNewNPC)victim ).ProcessShieldDestruction();
					}
				}
				
				delete damage_action;
			}
		}
	}
}	


statemachine class W3StoneTrap extends CGameplayEntity 
{	
	var i,size 																	: int;
	var victim 																	: CActor;
	var victims 																: array< CActor >;
	var fxEntities                                                              : array< CEntity >;
	var spellpower_final														: float;
	var aard_hit_ents															: array< CEntity >;
	var pillar																	: W3SpellsRockPillar;
	var tempname																: string;
	var worldPos 																: Vector;
	var polarAngle, yrdenRange, unitAngle 										: float;
	var runePositionLocal, runePositionGlobal 									: Vector;
	var entities_trap															: array< CGameplayEntity >;
	var duration																: float;

	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		duration = 15;
		duration += duration * ( GetMagicVigil().get_magic_spellpower() * 0.5 );
		duration = 5;
		
		AddTimer( 'destroy_stone_trap', duration );
		
		tempname = "dlc\magicspellsrev\data\entities\rockwatcher_pillar.w2ent";
		create_stone_trap();
	}
	
	function create_stone_trap()
	{
		yrdenRange = 3;
		size = 10;
		
		for( i=0; i<size; i+=1 )
		{
			unitAngle = 2 * Pi() / size;
			
			polarAngle = unitAngle * i;
			
			runePositionLocal.X = yrdenRange * CosF( polarAngle );
			runePositionLocal.Y = yrdenRange * SinF( polarAngle );
			runePositionLocal.Z = 0.f;
			
			runePositionGlobal = GetWorldPosition() + runePositionLocal;			
			
			pillar = (W3SpellsRockPillar)theGame.CreateEntity( (CEntityTemplate)LoadResource( tempname, true ), TraceFloor( runePositionGlobal ), GetWorldRotation() );
			pillar.AddTag( 'stone_trap_spells' );
			pillar.AddTimer( 'destroy_stone_trap', duration );
		}
		
		stop_targets_within_act( 3 );
		
		AddTimer( 'stop_targets_within', 0.3, true );
	}
	
	timer function stop_targets_within(deltaTime : float, id : int) 
	{
		stop_targets_within_act( 2.7 );
	}
	
	function stop_targets_within_act ( range : float ) 
	{
		FindGameplayEntitiesInRange(entities_trap, this, range, 100 );
		if( entities_trap.Size()>0 )
		{
			for ( i = 0; i <= entities_trap.Size(); i+=1 )
			{
				victim = (CActor)entities_trap[i];
				if ( victim != thePlayer && victim.IsAlive() && victim.IsOnGround() && IsRequiredAttitudeBetween(thePlayer, victim, true, false, false) 
					&& !victims.Contains( victim ) )
				{
					victim.EnablePathEngineAgent(false);
					victims.PushBack( victim );
				}
			}
		}
	}
	
    timer function destroy_stone_trap(deltaTime : float, id : int) 
	{
		RemoveTimer('stop_targets_within');
		
		RemoveTag( 'stone_trap_spells' );
		DestroyAfter(1);
		
		for ( i = 0; i <= victims.Size(); i+=1 )
		{
			victims[i].EnablePathEngineAgent(true);
		}
	}
}

statemachine class W3PermafrostTrap extends CGameplayEntity 
{	
	var i 																		: int;
	var victims 																: array< CActor >;
	var fxEntities                                                              : array< CEntity >;
	var spellpower_final														: float;
	var aard_hit_ents															: array< CEntity >;
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		AddTimer('check_for_targets_permafrost_trap',0.1, true);
		AddTimer('deal_damage_permafrost_trap',0.1, true);
		AddTimer('permafrost_clear_hits',1.0f, true);
		PlayEffect('ignition');
		
		spellpower_final = 0;
	}
	
	timer function permafrost_clear_hits(deltaTime : float, id : int) 
	{
		aard_hit_ents.Clear();
	}
	
    timer function destroy_permafrost_trap(deltaTime : float, id : int) 
	{
		StopAllEffects();
		DestroyAfter(3);
		RemoveTimer('check_for_targets_permafrost_trap');
		RemoveTimer('deal_damage_permafrost_trap');
		RemoveTimer('permafrost_clear_hits');
		
		if ( fxEntities.Size() >0 )
		{
			for ( i = 0; i <= fxEntities.Size(); i+=1 )
			{
				fxEntities[i].StopAllEffects();
				fxEntities[i].DestroyAfter(2);
			}
		}
	}
	
	event OnDestroyed()
	{
	}

	timer function check_for_targets_permafrost_trap(deltaTime : float, id : int) 
	{
		var entities_trap		: array< CGameplayEntity >;
		var victim 				: CActor;
		var fxEntity			: CEntity;
		
		if ( spellpower_final <=0 )
		{
			if ( HasTag('spells_from_sign') )
			{
				spellpower_final = GetMagicVigil().get_magic_spellpower();
			}
			else
			{
				spellpower_final = get_spellpower_spells( true );
			}
		}
		
		FindGameplayEntitiesInRange(entities_trap, this, 5, 100 );
		
		if( entities_trap.Size()>0 )
		{
			for ( i = 0; i <= entities_trap.Size(); i+=1 )
			{
				victim = (CActor)entities_trap[i];
				
				if ( VecDistance( entities_trap[i].GetWorldPosition(), this.GetWorldPosition() ) <= 2.7 )
				{
					if ( !aard_hit_ents.Contains( entities_trap[i] ) && !entities_trap[i].HasTag('spells_custom_projs') )
					{
						entities_trap[i].OnAardHit( NULL );
						aard_hit_ents.PushBack( entities_trap[i] );
					}
					
					if ( victim && victim.IsAlive() && victim.GetDistanceFromGround( 2 ) < 1.5f && IsRequiredAttitudeBetween(thePlayer, victim, true, false, false) )
					{
						if ( !victims.Contains( victim ) )
						{
							victims.PushBack( victim );
							fxEntity = victim.CreateFXEntityAtPelvis( 'permafrost_effects', true );
							fxEntity.PlayEffect( 'permafrost_burning' );
							fxEntities.PushBack(fxEntity);
						}
					}
				}
				
				if ( victim && ( victim.GetDistanceFromGround( 2 ) > 1.5f || VecDistance( victim.GetWorldPosition(), this.GetWorldPosition() ) > 2.7 ) )
				{
					victims.Remove( victim );
				}
			}
		}
		
		if ( fxEntities.Size() >0 )
		{
			for ( i = 0; i <= fxEntities.Size(); i+=1 )
			{
				if ( VecDistance( fxEntities[i].GetWorldPosition(), this.GetWorldPosition() ) > 2.7  )
				{
					fxEntities[i].StopAllEffects();
					fxEntities[i].DestroyAfter(2);
				}
			}
		}
	}
	
	timer function deal_damage_permafrost_trap(deltaTime : float, id : int) 
	{
		var victim 				: CActor;
		var damage_action 		: W3DamageAction;
		var damage_value 		: float;
		var heal 				: float;
		
		if( victims.Size() >0 )
		{
			for ( i = 0; i <= victims.Size(); i+=1 )
			{
				victim = (CActor)victims[i];
				
				damage_value = get_damage_value_for_trap( victim, spellpower_final );
				if ( !HasTag('spells_from_sign') )
				{
					damage_value += damage_value * get_manual_aiming_dmg_mod();	  
				}
				damage_value *= deltaTime;
				
				damage_action =  new W3DamageAction in this;
				damage_action.Initialize( thePlayer, victim, this, thePlayer.GetName()+"_sign", EHRT_None, CPS_Undefined, false, false, true, false);
				damage_action.SetIsDoTDamage( deltaTime );
				damage_action.AddDamage( theGame.params.DAMAGE_NAME_FROST, sp_frost_dmg_mod() * damage_value );
				damage_action.SetHitAnimationPlayType(EAHA_ForceNo);
				damage_action.SetProcessBuffsIfNoDamage(true);
				damage_action.SetHitEffect('');
				damage_action.SetHitEffect('', true );
				damage_action.SetHitEffect('', false, true);
				damage_action.SetHitEffect('', true, true);
				theGame.damageMgr.ProcessAction( damage_action );
				
				if ( ( (CNewNPC)victim ).IsShielded( thePlayer ) )
				{
					if ( ( (CNewNPC)victim ).GetBehaviorVariable( 'bShieldUp' ) == 0.f )
					{
						( (CNewNPC)victim ).SetBehaviorVariable( 'bShieldUp', 1.f );
					}
					
					if ( ( (CNewNPC)victim ).GetStaminaPercents() > 0.1 )
					{
						( (CNewNPC)victim ).DrainStamina(ESAT_FixedValue, 5 );
					}
					else 
					{
						( (CNewNPC)victim ).ProcessShieldDestruction();
					}
				}
				
				delete damage_action;
			}
		}
	}
}	


statemachine class W3FireGnosisTrap extends CGameplayEntity 
{	
	var i 																		: int;
	var victims 																: array< CActor >;
	var fxEntities                                                              : array< CEntity >;
	var spellpower_final														: float;
	var igni_hit_ents															: array< CEntity >;
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		AddTimer('check_for_targets_fire_trap', 0.1, true);
		AddTimer('deal_damage_fire_trap', 0.1, true);
		AddTimer('fire_trap_clear_hits', 1.0f, true);
		PlayEffect('ignition');
		
		spellpower_final = 0;
		
		//theGame.witcherLog.AddMessage("victims    " + (string)( victims.Size() ) );	
	}
	
	timer function fire_trap_clear_hits(deltaTime : float, id : int) 
	{
		igni_hit_ents.Clear();
	}
	
    timer function destroy_fire_trap(deltaTime : float, id : int) 
	{
		StopAllEffects();
		DestroyAfter(3);
		RemoveTimer('check_for_targets_fire_trap');
		RemoveTimer('deal_damage_fire_trap');
		RemoveTimer('fire_trap_clear_hits');
		
		if ( victims.Size() >0 )
		{
			for ( i = 0; i <= victims.Size(); i+=1 )
			{
				victims[i].RemoveTag('victim_fire_trap');
				victims[i].AddTimer('Runeword1DisableFireFX', 0.f);
			}
		}
	}
	
	event OnDestroyed()
	{
	}

	timer function check_for_targets_fire_trap(deltaTime : float, id : int) 
	{
		var entities_trap		: array< CGameplayEntity >;
		var victim 				: CActor;
		var fxEntity			: CEntity;
		
		if ( spellpower_final <=0 )
		{
			if ( HasTag('spells_from_sign') )
			{
				spellpower_final = GetMagicVigil().get_magic_spellpower();
			}
			else
			{
				spellpower_final = get_spellpower_spells( true );
			}
		}
		
		FindGameplayEntitiesInRange(entities_trap, this, 5, 100 );
		
		if( entities_trap.Size()>0 )
		{
			for ( i = 0; i <= entities_trap.Size(); i+=1 )
			{
				victim = (CActor)entities_trap[i];
				
				if ( VecDistance( entities_trap[i].GetWorldPosition(), this.GetWorldPosition() ) <= 2.7 )
				{
					if ( !igni_hit_ents.Contains( entities_trap[i] ) && !entities_trap[i].HasTag('spells_custom_projs') )
					{
						entities_trap[i].OnIgniHit( NULL );
						igni_hit_ents.PushBack( entities_trap[i] );
					}
					
					if ( victim && victim.IsAlive() && victim.GetDistanceFromGround( 2 ) < 1.5f && IsRequiredAttitudeBetween(thePlayer, victim, true, false, false) )
					{
						if ( !victim.HasTag('victim_fire_trap') )
						{
							victim.AddTag('victim_fire_trap');
							victim.PlayEffect('critical_burning');
							victims.PushBack( victim );
						}
					}
				}
				
				if ( victim && ( victim.GetDistanceFromGround( 2 ) > 1.5f || VecDistance( victim.GetWorldPosition(), this.GetWorldPosition() ) > 2.7 ) )
				{
					if ( victim.HasTag('victim_fire_trap') )
					{
						victim.RemoveTag('victim_fire_trap');
						victim.AddTimer('Runeword1DisableFireFX', 0.f);
						victims.Remove( victim );
					}
				}
			}
		}
	}
	
	timer function deal_damage_fire_trap(deltaTime : float, id : int) 
	{
		var victim 				: CActor;
		var damage_action 		: W3DamageAction;
		var damage_value 		: float;
		var heal 				: float;
		
		if( victims.Size() >0 )
		{
			for ( i = 0; i <= victims.Size(); i+=1 )
			{
				victim = (CActor)victims[i];
				
				damage_value = get_damage_value_for_trap( victim, spellpower_final );
				if ( !HasTag('spells_from_sign') )
				{
					damage_value += damage_value * get_manual_aiming_dmg_mod();	  
				}
				//theGame.witcherLog.AddMessage("DAMAGE  = " + (string)damage_value );
				damage_value *= deltaTime;
				
				damage_action =  new W3DamageAction in this;
				damage_action.Initialize( thePlayer, victim, this, thePlayer.GetName()+"_sign", EHRT_None, CPS_Undefined, false, false, true, false);
				damage_action.SetIsDoTDamage( deltaTime );
				damage_action.AddDamage( theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() * damage_value );
				damage_action.SetHitAnimationPlayType(EAHA_ForceNo);
				damage_action.SetProcessBuffsIfNoDamage(true);
				damage_action.SetHitEffect('');
				damage_action.SetHitEffect('', true );
				damage_action.SetHitEffect('', false, true);
				damage_action.SetHitEffect('', true, true);
				theGame.damageMgr.ProcessAction( damage_action );
				
				if ( ( (CNewNPC)victim ).IsShielded( thePlayer ) )
				{
					if ( ( (CNewNPC)victim ).GetBehaviorVariable( 'bShieldUp' ) == 0.f )
					{
						( (CNewNPC)victim ).SetBehaviorVariable( 'bShieldUp', 1.f );
					}
					
					if ( ( (CNewNPC)victim ).GetStaminaPercents() > 0.1 )
					{
						( (CNewNPC)victim ).DrainStamina(ESAT_FixedValue, 5 );
					}
					else 
					{
						( (CNewNPC)victim ).ProcessShieldDestruction();
					}
				}
				
				/*
				if(GetWitcherPlayer().GetHorseManager().IsItemEquippedByName('vampire_tome'))
				{
					heal = ClampF(damage_value, 0, (thePlayer.GetMaxHealth()*0.01));
					thePlayer.Heal(heal);
				}
				*/
				
				delete damage_action;
			}
		}
	}
}	




statemachine class W3BlackFireTrap extends CGameplayEntity 
{	
	var i 																		: int;
	var victims 																: array< CActor >;
	var fxEntities                                                              : array< CEntity >;
	var spellpower_final														: float;
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		AddTimer('check_for_targets_black_trap',0.1, true);
		AddTimer('deal_damage',0.1, true);
		PlayEffect('ignition');
		
		spellpower_final = 0;
		
		//theGame.witcherLog.AddMessage("victims    " + (string)( victims.Size() ) );	
	}
	
    timer function destroy_black_trap(deltaTime : float, id : int) 
	{
		StopAllEffects();
		DestroyAfter(3);
		RemoveTimer('check_for_targets_black_trap');
		RemoveTimer('deal_damage');
		
		if ( fxEntities.Size() >0 )
		{
			for ( i = 0; i <= fxEntities.Size(); i+=1 )
			{
				fxEntities[i].StopAllEffects();
				fxEntities[i].DestroyAfter(2);
			}
		}
	}
	
	event OnDestroyed()
	{
	}

	timer function check_for_targets_black_trap(deltaTime : float, id : int) 
	{
		var entities_trap		: array< CGameplayEntity >;
		var victim 				: CActor;
		var fxEntity			: CEntity;
		
		if ( spellpower_final <=0 )
		{
			if ( HasTag('spells_from_sign') )
			{
				spellpower_final = GetMagicVigil().get_magic_spellpower();
			}
			else
			{
				spellpower_final = get_spellpower_spells( true );
			}
		}
		
		FindGameplayEntitiesInRange(entities_trap, this, 5, 100,,FLAG_Attitude_Hostile+FLAG_OnlyAliveActors+FLAG_ExcludePlayer );
		
		if( entities_trap.Size()>0 )
		{
			for ( i = 0; i <= entities_trap.Size(); i+=1 )
			{
				victim = (CActor)entities_trap[i];
				
				if ( VecDistance( victim.GetWorldPosition(), this.GetWorldPosition() ) <= 2.7 )
				{
					if ( victim && victim.IsAlive() && victim.GetDistanceFromGround( 2 ) < 1.5f && IsRequiredAttitudeBetween(thePlayer, victim, true, false, false) )
					{
						if ( !victims.Contains( victim ) )
						{
							victims.PushBack( victim );
							fxEntity = victim.CreateFXEntityAtPelvis( 'black_fire_effects', true );
							fxEntity.PlayEffect( 'black_burning_trap' );
							fxEntities.PushBack(fxEntity);
						}
					}
				}
				if ( victim && ( victim.GetDistanceFromGround( 2 ) > 1.5f || VecDistance( victim.GetWorldPosition(), this.GetWorldPosition() ) > 2.7 ) )
				{
					victims.Remove( victim );
				}
			}
		}
		
		if ( fxEntities.Size() >0 )
		{
			for ( i = 0; i <= fxEntities.Size(); i+=1 )
			{
				if ( VecDistance( fxEntities[i].GetWorldPosition(), this.GetWorldPosition() ) > 2.7  )
				{
					fxEntities[i].StopAllEffects();
					fxEntities[i].DestroyAfter(2);
				}
			}
		}
	}
	
	timer function deal_damage(deltaTime : float, id : int) 
	{
		var victim 				: CActor;
		var damage_action 		: W3DamageAction;
		var damage_value 		: float;
		var heal 				: float;
		
		if( victims.Size() >0 )
		{
			for ( i = 0; i <= victims.Size(); i+=1 )
			{
				victim = (CActor)victims[i];
				
				damage_value = get_damage_value_for_special_trap( victim, spellpower_final );
				if ( !HasTag('spells_from_sign') )
				{
					damage_value += damage_value * get_manual_aiming_dmg_mod();	  
				}
				damage_value *= deltaTime;
				
				damage_action =  new W3DamageAction in this;
				damage_action.Initialize( thePlayer, victim, this, thePlayer.GetName()+"_sign", EHRT_None, CPS_Undefined, false, false, true, false);
				damage_action.SetIsDoTDamage( deltaTime );
				damage_action.AddDamage( theGame.params.DAMAGE_NAME_DIRECT, sp_direct_dmg_mod() * damage_value );
				damage_action.SetHitAnimationPlayType(EAHA_ForceNo);
				damage_action.SetProcessBuffsIfNoDamage(true);
				damage_action.SetHitEffect('');
				damage_action.SetHitEffect('', true );
				damage_action.SetHitEffect('', false, true);
				damage_action.SetHitEffect('', true, true);
				theGame.damageMgr.ProcessAction( damage_action );
				
				if ( ( (CNewNPC)victim ).IsShielded( thePlayer ) )
				{
					if ( ( (CNewNPC)victim ).GetBehaviorVariable( 'bShieldUp' ) == 0.f )
					{
						( (CNewNPC)victim ).SetBehaviorVariable( 'bShieldUp', 1.f );
					}
					
					if ( ( (CNewNPC)victim ).GetStaminaPercents() > 0.1 )
					{
						( (CNewNPC)victim ).DrainStamina(ESAT_FixedValue, 5 );
					}
					else 
					{
						( (CNewNPC)victim ).ProcessShieldDestruction();
					}
				}
				
				delete damage_action;
			}
		}
	}
}	


statemachine class W3RimrgandMouth extends CGameplayEntity 
{	
	var i 																		: int;
	var victims 																: array< CActor >;
	var fxEntities                                                              : array< CEntity >;
	var spellpower_final														: float;
	var aard_hit_ents															: array< CEntity >;
	var damage_action 															: W3DamageAction;
	var ticket 																	: SMovementAdjustmentRequestTicket;
	var movementAdjustor														: CMovementAdjustor;
	var movingAgent																: CMovingAgentComponent;
	var damage_value															: float;
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		AddTimer('check_for_targets_winter_mouth', 0.1, true);
		AddTimer('rimrgand_clear_hits', 1.0f, true);
		PlayEffect('main');
		PlayEffect('light');
		
		SoundEvent("magic_man_tornado_loop_start");
		
		spellpower_final = 0;
	}
	
	timer function rimrgand_clear_hits(deltaTime : float, id : int) 
	{
		aard_hit_ents.Clear();
	}
	
    timer function destroy_winter_mouth(deltaTime : float, id : int) 
	{
		StopEffect('main');
		DestroyAfter(3);
		AddTimer('destroy_light_effect',1.5 );
		RemoveTimer('check_for_targets_winter_mouth');
		
		SoundEvent("magic_man_tornado_loop_stop");
	}
    timer function destroy_light_effect(deltaTime : float, id : int) 
	{
		StopEffect('light');
	}
	
	event OnDestroyed()
	{
	}

	timer function check_for_targets_winter_mouth(deltaTime : float, id : int) 
	{
		var entities_trap		: array< CGameplayEntity >;
		var victim 				: CActor;
		var fxEntity			: CEntity;
		var actors				: array< CActor >;
		var actor				: CActor;
		
		if ( spellpower_final <=0 )
		{
			if ( HasTag('spells_from_sign') )
			{
				spellpower_final = GetMagicVigil().get_magic_spellpower();
			}
			else
			{
				spellpower_final = get_spellpower_spells( true );
			}
			
			//theGame.witcherLog.AddMessage("Sign SKILL  " + (string)GetMagicVigil().signskill );
			//theGame.witcherLog.AddMessage("Spellpower Final  " + GetMagicVigil().spellpower_final );
		}
		
		
		actors = GetWitcherPlayer().GetNPCsAndPlayersInRange( 20, 100, '', FLAG_Attitude_Hostile+FLAG_OnlyAliveActors );
		for( i = 0; i < actors.Size(); i += 1 )
		{	
			actor = (CActor)actors[i];
			movingAgent = actor.GetMovingAgentComponent();
			movementAdjustor = actor.GetMovingAgentComponent().GetMovementAdjustor();;
			ticket = movementAdjustor.CreateNewRequest( 'rimrgand_devour');
			movementAdjustor.MaxRotationAdjustmentSpeed( ticket, 3 );
			movementAdjustor.MaxLocationAdjustmentSpeed( ticket, 3 );
			movementAdjustor.Continuous( ticket );
			movementAdjustor.KeepActiveFor( ticket, deltaTime );
			movementAdjustor.SlideTowards( ticket, this );
			if( VecDistance( actor.GetWorldPosition(), this.GetWorldPosition() ) <= 1 ){	movementAdjustor.Cancel( ticket ); 	 }
		}
		
		
		FindGameplayEntitiesInRange(entities_trap, this, 5, 100 );
		
		if( entities_trap.Size()>0 )
		{
			for ( i = 0; i <= entities_trap.Size(); i+=1 )
			{
				
				if ( VecDistance( entities_trap[i].GetWorldPosition(), this.GetWorldPosition() ) <= 3 )
				{
					if ( !aard_hit_ents.Contains( entities_trap[i] ) && !entities_trap[i].HasTag('spells_custom_projs') )
					{
						entities_trap[i].OnAardHit( NULL );
						aard_hit_ents.PushBack( entities_trap[i] );
					}
				
					victim = (CActor)entities_trap[i];
					if ( IsRequiredAttitudeBetween(thePlayer, victim, true, false, false)  )
					{
						damage_value = get_damage_value_for_special_trap( victim, spellpower_final );
						damage_value *= deltaTime;
						
						damage_action =  new W3DamageAction in this;
						damage_action.Initialize( thePlayer, victim, this, thePlayer.GetName()+"_sign", EHRT_None, CPS_Undefined, false, false, true, false);
						damage_action.SetIsDoTDamage( deltaTime );
						damage_action.AddDamage( theGame.params.DAMAGE_NAME_FROST, sp_frost_dmg_mod() * damage_value );
						damage_action.SetHitAnimationPlayType(EAHA_ForceNo);
						damage_action.SetProcessBuffsIfNoDamage(true);
						damage_action.SetHitEffect('');
						damage_action.SetHitEffect('', true );
						damage_action.SetHitEffect('', false, true);
						damage_action.SetHitEffect('', true, true);
						
						if ( spells_can_dismember( victim ) )
						{
							damage_action.SetForceExplosionDismemberment();
						}
						
						theGame.damageMgr.ProcessAction( damage_action );
						
						if ( ( (CNewNPC)victim ).IsShielded( thePlayer ) )
						{
							if ( ( (CNewNPC)victim ).GetBehaviorVariable( 'bShieldUp' ) == 0.f )
							{
								( (CNewNPC)victim ).SetBehaviorVariable( 'bShieldUp', 1.f );
							}
							
							if ( ( (CNewNPC)victim ).GetStaminaPercents() > 0.1 )
							{
								( (CNewNPC)victim ).DrainStamina(ESAT_FixedValue, 5 );
							}
							else 
							{
								( (CNewNPC)victim ).ProcessShieldDestruction();
							}
						}
						
						delete damage_action;
					}
				}
			}
		}
	}
}	

statemachine class W3FireVortex extends CGameplayEntity 
{	
	var i 																		: int;
	var victims 																: array< CActor >;
	var fxEntities                                                              : array< CEntity >;
	var spellpower_final														: float;
	var fire_hit_ents															: array< CEntity >;
	var damage_action 															: W3DamageAction;
	var ticket 																	: SMovementAdjustmentRequestTicket;
	var movementAdjustor														: CMovementAdjustor;
	var movingAgent																: CMovingAgentComponent;
	var damage_value															: float;
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		AddTimer('check_for_targets_fire_vortex', 0.1, true);
		AddTimer('fire_vortex_clear_hits', 1.0f, true);
		PlayEffect('main');
		PlayEffect('light');
		
		SoundEvent("sign_igni_charge_loop_play");
		
		spellpower_final = 0;
	}
	
	timer function fire_vortex_clear_hits(deltaTime : float, id : int) 
	{
		fire_hit_ents.Clear();
	}
	
    timer function destroy_fire_vortex(deltaTime : float, id : int) 
	{
		StopEffect('main');
		DestroyAfter(3);
		AddTimer('destroy_light_effect',1.5 );
		RemoveTimer('check_for_targets_fire_vortex');
		
		SoundEvent("sign_igni_charge_loop_stop");
	}
    timer function destroy_light_effect(deltaTime : float, id : int) 
	{
		StopEffect('light');
	}
	
	event OnDestroyed()
	{
	}

	timer function check_for_targets_fire_vortex(deltaTime : float, id : int) 
	{
		var entities_trap		: array< CGameplayEntity >;
		var victim 				: CActor;
		var fxEntity			: CEntity;
		var actors				: array< CActor >;
		var actor				: CActor;
		
		if ( spellpower_final <=0 )
		{
			if ( HasTag('spells_from_sign') )
			{
				spellpower_final = GetMagicVigil().get_magic_spellpower();
			}
			else
			{
				spellpower_final = get_spellpower_spells( true );
			}
			
			//theGame.witcherLog.AddMessage("Sign SKILL  " + (string)GetMagicVigil().signskill );
			//theGame.witcherLog.AddMessage("Spellpower Final  " + GetMagicVigil().spellpower_final );
		}
		
		
		actors = GetWitcherPlayer().GetNPCsAndPlayersInRange( 20, 100, '', FLAG_Attitude_Hostile+FLAG_OnlyAliveActors );
		for( i = 0; i < actors.Size(); i += 1 )
		{	
			actor = (CActor)actors[i];
			movingAgent = actor.GetMovingAgentComponent();
			movementAdjustor = actor.GetMovingAgentComponent().GetMovementAdjustor();;
			ticket = movementAdjustor.CreateNewRequest( 'fire_devour');
			movementAdjustor.MaxRotationAdjustmentSpeed( ticket, 3 );
			movementAdjustor.MaxLocationAdjustmentSpeed( ticket, 3 );
			movementAdjustor.Continuous( ticket );
			movementAdjustor.KeepActiveFor( ticket, deltaTime );
			movementAdjustor.SlideTowards( ticket, this );
			if( VecDistance( actor.GetWorldPosition(), this.GetWorldPosition() ) <= 1 ){	movementAdjustor.Cancel( ticket ); 	 }
		}
		
		
		FindGameplayEntitiesInRange(entities_trap, this, 5, 100 );
		
		if( entities_trap.Size()>0 )
		{
			for ( i = 0; i <= entities_trap.Size(); i+=1 )
			{
				
				if ( VecDistance( entities_trap[i].GetWorldPosition(), this.GetWorldPosition() ) <= 3 )
				{
					if ( !fire_hit_ents.Contains( entities_trap[i] ) && !entities_trap[i].HasTag('spells_custom_projs') )
					{
						entities_trap[i].OnIgniHit( NULL );
						fire_hit_ents.PushBack( entities_trap[i] );
					}
				
					victim = (CActor)entities_trap[i];
					if ( IsRequiredAttitudeBetween(thePlayer, victim, true, false, false)  )
					{
						damage_value = get_damage_value_for_special_trap( victim, spellpower_final );
						damage_value *= deltaTime;
						
						damage_action =  new W3DamageAction in this;
						damage_action.Initialize( thePlayer, victim, this, thePlayer.GetName()+"_sign", EHRT_None, CPS_Undefined, false, false, true, false);
						damage_action.SetIsDoTDamage( deltaTime );
						damage_action.AddDamage( theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() * damage_value );
						damage_action.SetHitAnimationPlayType(EAHA_ForceNo);
						damage_action.SetProcessBuffsIfNoDamage(true);
						damage_action.SetHitEffect('');
						damage_action.SetHitEffect('', true );
						damage_action.SetHitEffect('', false, true);
						damage_action.SetHitEffect('', true, true);
						
						victim.PlayEffectSingle('critical_burning');
						victim.AddTimer('Runeword1DisableFireFX', 1.0f);
						
						if ( spells_can_dismember( victim ) )
						{
							damage_action.SetForceExplosionDismemberment();
						}
						
						theGame.damageMgr.ProcessAction( damage_action );
						
						if ( ( (CNewNPC)victim ).IsShielded( thePlayer ) )
						{
							if ( ( (CNewNPC)victim ).GetBehaviorVariable( 'bShieldUp' ) == 0.f )
							{
								( (CNewNPC)victim ).SetBehaviorVariable( 'bShieldUp', 1.f );
							}
							
							if ( ( (CNewNPC)victim ).GetStaminaPercents() > 0.1 )
							{
								( (CNewNPC)victim ).DrainStamina(ESAT_FixedValue, 5 );
							}
							else 
							{
								( (CNewNPC)victim ).ProcessShieldDestruction();
							}
						}
						
						delete damage_action;
					}
				}
			}
		}
	}
}	


statemachine class W3SpellsStorm extends CGameplayEntity 
{	
	var storm 					: CEntity;

	event OnSpawned( spawnData : SEntitySpawnData )
	{
		AddTimer('stop_storm', 110);
		
		storm = theGame.CreateEntity( (CEntityTemplate) LoadResource( "dlc\magicspellsrev\data\entities\old_gods_storm.w2ent",true ), 
		thePlayer.GetWorldPosition(), thePlayer.GetWorldRotation() );
		storm.PlayEffect('ritual_storm');
		storm.StopAllEffectsAfter(60);
		storm.DestroyAfter(120);
		storm.AddTag('old_gods_storm_effect');
		
		GetMagicVigil().set_storm( true );
	}
	
	timer function destroy_storm(deltaTime : float, id : int) 
	{
		theGame.GetEntityByTag( 'old_gods_storm_effect' ).StopAllEffects();
		theGame.GetEntityByTag( 'old_gods_storm_effect' ).DestroyAfter(20);
		GetMagicVigil().set_storm( false );
	}
	
	timer function stop_storm(deltaTime : float, id : int) 
	{
		GetMagicVigil().set_storm( false );
		DestroyAfter(1);
	}
}

state OldGodsStorm in W3SpellsStorm
{
	var lightning_strike   				: CEntity;
	var stormpos						: Vector;
	var randY, randX, rand				: float;

	event OnEnterState( prevStateName : name )
	{
		//theGame.witcherLog.AddMessage("Old Gods Storm    "  );	
		
		process_storm_init();
	}
	
	private entry function process_storm_init()
	{
		//theGame.witcherLog.AddMessage("process storm_init =>  "  );	
		
		stormpos = thePlayer.GetWorldPosition();
		lightning_strike = theGame.CreateEntity( (CEntityTemplate)LoadResource("dlc\magicspellsrev\data\entities\old_gods_storm_strike.w2ent",true), stormpos, thePlayer.GetWorldRotation() );  
		lightning_strike.DestroyAfter(120);
		
		parent.PlayEffect('storm_effect');
		parent.PlayEffect('storm_effect1');
		
		thePlayer.SoundEvent('fx_amb_thunder_close');
		
		Sleep( 5 );
		thePlayer.SoundEvent('fx_amb_sq209_thunder_close_2d');
		Sleep( 5 );
		
		process_storm();
		
	}
	
	
	private entry function process_storm()
	{
		var randenemy 			: int;
		var enemies				: array< CActor >;
		var strikedmg			: float;
		var effect_entity		: CEntity;
		var strike 				: W3DamageAction;
	
		//theGame.witcherLog.AddMessage("process storm post  === > "  );	
	
		while ( GetMagicVigil().storm_is_active )
		{
			stormpos = thePlayer.GetWorldPosition();
			randY = RandRangeF( 15.0, 2.0 );
			randX = RandRangeF( 15.0, 2.0 );
			
			if( RandF() <0.5 )	{ stormpos.Y += randY; }	else{ stormpos.Y -= randY; }
			if( RandF() <0.5 ) 	{ stormpos.X += randX; }	else{ stormpos.X -= randX; } 
			
			lightning_strike.Teleport( TraceFloor(stormpos) );
			lightning_strike.PlayEffect('lightning');
			
			rand = RandRangeF( 1.6, 0.1 );
			thePlayer.SoundEvent('sq_sk_205_short_gusty');

				enemies = GetWitcherPlayer().GetNPCsAndPlayersInRange( 20, 100, '', FLAG_Attitude_Hostile+FLAG_OnlyAliveActors );
				if(RandF() < 0.33 && enemies.Size()>0)
				{
					randenemy = RandRange ( 0, enemies.Size() );
						
					strike =  new W3DamageAction in theGame.damageMgr;
					strike.Initialize( thePlayer, enemies[randenemy], this, thePlayer.GetName()+"_sign", EHRT_Light, CPS_Undefined, false, false, true, false);
					
					strikedmg = enemies[randenemy].GetMaxHealth()*0.2; 											//theGame.witcherLog.AddMessage("    strikedmg   " + strikedmg );
					strikedmg += strikedmg * ( GetMagicVigil().get_magic_spellpower() * get_spellpower_mult() );
					strikedmg *= RandRangeF( 1.3, 0.7 );
					strikedmg += strikedmg * get_storm_dmg_mod();
					strikedmg += strikedmg * get_overall_mult();
					
					strike.AddDamage( theGame.params.DAMAGE_NAME_SHOCK, sp_shock_dmg_mod() *  strikedmg );
					strike.SetHitAnimationPlayType(EAHA_ForceNo);
					strike.SetProcessBuffsIfNoDamage(true);
					
					if ( spells_can_dismember( enemies[randenemy] ) )
					{
						strike.SetForceExplosionDismemberment();
					}
					
					strike.AddEffectInfo(EET_Stagger);
					
					effect_entity = enemies[randenemy].CreateFXEntityAtPelvis( 'explosions', true );
					effect_entity.PlayEffect( 'old_gods_hit' );
					effect_entity.DestroyAfter(5);
					
					theGame.damageMgr.ProcessAction( strike );
					delete strike;
					
					lightning_strike.Teleport( enemies[randenemy].GetWorldPosition() );
					lightning_strike.PlayEffect('lightning');
				}

			Sleep( rand );
		}
	}
}


statemachine class SpellsArenaDancers extends CGameplayEntity 
{	
	var i,z 										: int;
	var entities_trap								: array< CGameplayEntity >;
	var active										: bool;
	var player_inside								: bool;
	var effects, sword_effects						: array< CEntity >;
	var damage_action 								: W3DamageAction;
	var victims 									: array< CActor >;
	var bonenames									: array< name >;
	var abs_to_block								: array< name >;
	var add_eff, add_eff2							: CEntity;
	var rot 										: EulerAngles;
	var effect_sword								: CEntity;
	var vector_sword								: Vector;
	var euler_sword									: EulerAngles;
	var steelcomp, silvercomp, scabbardscomp 		: CDrawableComponent;
	var xbow, swordsteel, swordsilver, effect 		: CEntity;
	var steelid,silverid, xid						: SItemUniqueId;
	var n											: float;
	var quen_hack									: bool;
	var slowfactor									: float;

	event OnSpawned( spawnData : SEntitySpawnData )
	{
		abs_to_block.Clear();
		abs_to_block.PushBack( 'Swarm' );	
		abs_to_block.PushBack( 'SwarmShield' );	
		abs_to_block.PushBack( 'SwarmTeleport' );	
		abs_to_block.PushBack( 'Shapeshifter' );	
		abs_to_block.PushBack( 'ShadowForm' );	
		abs_to_block.PushBack( 'MistForm' );	
		abs_to_block.PushBack( 'MistCharge' );	
		abs_to_block.PushBack( 'Flashstep' );	
		abs_to_block.PushBack( 'FullMoon' );	
		abs_to_block.PushBack( 'EssenceRegen' );	
		abs_to_block.PushBack( 'Teleport' );	
		abs_to_block.PushBack( 'SpawnArena' );	
		abs_to_block.PushBack( 'Magical' );	
	
		PlayEffect('energy_circle');
		AddTimer( 'check_area', 0.1, true );
		player_inside = false;
		
		rot = GetWorldRotation();
		
		add_eff = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\scroll_of_beauty_effects.w2ent", true ), 
		GetWorldPosition(), rot );
		add_eff.PlayEffect('energy_circle_add');
		
		rot.Yaw -= 180;
		add_eff2 = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\scroll_of_beauty_effects.w2ent", true ), 
		GetWorldPosition(), rot );
		add_eff2.PlayEffect('energy_circle_add');
		
		//magic_keira_hand_fx_shield_loop_start
		
		//magic_yennefer_necromancy_loop_start
		SoundEvent("magic_yennefer_mind_control_loop_start");
		SoundEvent("magic_yennefer_mind_control_loop_start");
	}
	
	timer function destroy_energy_area(deltaTime : float, id : int) 
	{
		player_inside = false;
		StopAllEffects();
		RemoveTimer('check_area');
		DestroyAfter(3);
		
		block_abs( true );
		apply_beauty( false );
		
		add_eff.StopAllEffects();
		add_eff.DestroyAfter(3);
		
		add_eff2.StopAllEffects();
		add_eff2.DestroyAfter(3);
		
		SoundEvent("magic_yennefer_mind_control_loop_stop");
	}
	
	timer function check_area(deltaTime : float, id : int) 
	{
		var actor 			: CActor;
		
		if ( !thePlayer.HasBuff( EET_EyeOfTheStorm ) && !theGame.IsDialogOrCutscenePlaying() )
		{
			if ( VecDistance( thePlayer.GetWorldPosition(), this.GetWorldPosition() ) <= 4 )
			{
				if ( !player_inside ) 
				{
					apply_beauty( true );
				}
				apply_hack();
			}
			else
			{
				if ( player_inside ) 
				{
					apply_beauty( false );
				}
			}
		}
		
		FindGameplayEntitiesInRange(entities_trap, this, 20, 100 );
		for ( i = 0; i <= entities_trap.Size(); i+=1 )
		{
			actor = (CActor)entities_trap[i];
			if ( !victims.Contains(actor) )
			{
				victims.PushBack(actor);
			}
			
			if (VecDistance( actor.GetWorldPosition(), this.GetWorldPosition() ) <= 4 )
			{
				if ( !actor.HasTag('spells_blocked_abs') )
				{
					actor.AddTag('spells_to_block_abs');
				}
			}
			else
			{
				if ( actor.HasTag('spells_blocked_abs') )
				{
					actor.AddTag('spells_to_unblock_abs');
				}
			}
		}
		block_abs();
	}
	
	function block_abs( optional force_disable : bool )
	{
		for ( i = 0; i <= victims.Size(); i+=1 )
		{
			if ( victims[i] != thePlayer )
			{
				if ( force_disable )
				{
					if ( victims[i].HasTag('spells_blocked_abs') )
					{
						for ( z = 0; z <= abs_to_block.Size(); z+=1 )
						{
							victims[i].BlockAbility(abs_to_block[z], false);
						}
						
						victims[i].RemoveTag('spells_blocked_abs');
						victims[i].RemoveTag('spells_to_unblock_abs');
						victims[i].RemoveTag('spells_to_block_abs');
					}
				}
				else
				{
					if ( victims[i].HasTag('spells_to_block_abs') )
					{
						for ( z = 0; z <= abs_to_block.Size(); z+=1 )
						{
							victims[i].BlockAbility(abs_to_block[z], true);
						}
						
						victims[i].AddTag('spells_blocked_abs');
						victims[i].RemoveTag('spells_to_block_abs');
					}
					
					if ( victims[i].HasTag('spells_to_unblock_abs')  )
					{
						for ( z = 0; z <= abs_to_block.Size(); z+=1 )
						{
							victims[i].BlockAbility(abs_to_block[z], false);
						}
						
						victims[i].RemoveTag('spells_blocked_abs');
						victims[i].RemoveTag('spells_to_unblock_abs');
					}
				}
			}
		}
	}
	
	function apply_beauty( value : bool )
	{
		if ( !value )
		{
			player_inside = false;
			theGame.RemoveTimeScale( theGame.GetTimescaleSource(7) );
		}
		else
		{
			player_inside = true;
			SoundEvent("magic_yennefer_q310_spell_01");
			
			slowfactor = 0.9 - ( GetMagicVigil().get_magic_spellpower() * 0.2 );
			slowfactor = ClampF(slowfactor, 0.4, 0.8);
			theGame.SetTimeScale( slowfactor, theGame.GetTimescaleSource(7), theGame.GetTimescalePriority(7) );
			theGame.RemoveTimeScale( theGame.GetTimescaleSource(7) );
			theGame.SetTimeScale( slowfactor, theGame.GetTimescaleSource(7), theGame.GetTimescalePriority(7) );
			//theGame.witcherLog.AddMessage("spellpower: " + ( GetMagicVigil().get_magic_spellpower() * 0.2 ) );
			//theGame.witcherLog.AddMessage("slowfactor: " + slowfactor);
			//theGame.witcherLog.AddMessage("slowfactor: " + slowfactor);
			//theGame.witcherLog.AddMessage("game scale: " + theGame.GetTimeScale());
			
		}
	}
	
	function apply_hack()
	{
		if ( theGame.GetTimeScale() != slowfactor )
		{
			theGame.SetTimeScale( slowfactor, theGame.GetTimescaleSource(7), theGame.GetTimescalePriority(7) );	
		}	
	}
}

statemachine class GraveWardenVeil extends CGameplayEntity 
{	
	var i,z 										: int;
	var entities_trap								: array< CGameplayEntity >;
	var active										: bool;
	var player_inside								: bool;
	var effects, sword_effects						: array< CEntity >;
	var damage_action 								: W3DamageAction;
	var victims 									: array< CActor >;
	var bonenames									: array< name >;
	var abs_to_block								: array< name >;
	var add_eff, add_eff2							: CEntity;
	var rot 										: EulerAngles;
	var effect_sword								: CEntity;
	var vector_sword								: Vector;
	var euler_sword									: EulerAngles;
	var steelcomp, silvercomp, scabbardscomp 		: CDrawableComponent;
	var xbow, swordsteel, swordsilver, effect 		: CEntity;
	var steelid,silverid, xid						: SItemUniqueId;
	var n											: float;
	var quen_hack									: bool;
	var slowfactor									: float;
	var sword										: CEntity;

	event OnSpawned( spawnData : SEntitySpawnData )
	{
		abs_to_block.Clear();
		abs_to_block.PushBack( 'Swarm' );	
		abs_to_block.PushBack( 'SwarmShield' );	
		abs_to_block.PushBack( 'SwarmTeleport' );	
		abs_to_block.PushBack( 'Shapeshifter' );	
		abs_to_block.PushBack( 'ShadowForm' );	
		abs_to_block.PushBack( 'MistForm' );	
		abs_to_block.PushBack( 'MistCharge' );	
		abs_to_block.PushBack( 'Flashstep' );	
		abs_to_block.PushBack( 'FullMoon' );	
		abs_to_block.PushBack( 'EssenceRegen' );	
		abs_to_block.PushBack( 'Teleport' );	
		abs_to_block.PushBack( 'SpawnArena' );	
		abs_to_block.PushBack( 'Magical' );	
	
		PlayEffect('energy_circle');
		AddTimer( 'check_area', 0.1, true );
		player_inside = false;
		
		rot = GetWorldRotation();
		
		add_eff = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\grave_warden_effects.w2ent", true ), 
		GetWorldPosition(), rot );
		add_eff.PlayEffect('energy_circle_add');
		
		rot.Yaw -= 180;
		add_eff2 = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\grave_warden_effects.w2ent", true ), 
		GetWorldPosition(), rot );
		add_eff2.PlayEffect('energy_circle_add');
		
		effect = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\grave_warden_veil_effect.w2ent", true), GetWorldPosition() );
		effect.CreateAttachment( thePlayer );
	
		sword = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\grave_warden_veil_sword_effect.w2ent", true), GetWorldPosition() );
		sword.CreateAttachment( thePlayer, 'r_weapon' , Vector( 0, 0, 0.5 ) );
		sword.AddTag('spells_veil_sword');
		
		
		//magic_keira_hand_fx_shield_loop_start
		
		//magic_yennefer_necromancy_loop_start
		SoundEvent("magic_keira_hand_fx_shield_loop_start");
		//SoundEvent("magic_yennefer_necromancy_loop_start");
		//SoundEvent("magic_yennefer_necromancy_loop_start");
	}
	
	timer function destroy_energy_area(deltaTime : float, id : int) 
	{
		player_inside = false;
		StopAllEffects();
		RemoveTimer('check_area');
		DestroyAfter(3);
		
		block_abs( true );
		torn_veil( false );
		
		effect.StopAllEffects();
		effect.DestroyAfter(5);
		
		sword.RemoveTag('spells_veil_sword');
		sword.StopAllEffects();
		sword.DestroyAfter(5);
		
		add_eff.StopAllEffects();
		add_eff.DestroyAfter(3);
		
		add_eff2.StopAllEffects();
		add_eff2.DestroyAfter(3);
		
		SoundEvent("magic_keira_hand_fx_shield_loop_stop");
	}
	
	timer function check_area(deltaTime : float, id : int) 
	{
		var actor 			: CActor;
	
		if ( VecDistance( thePlayer.GetWorldPosition(), this.GetWorldPosition() ) <= 4 )
		{
			if ( !player_inside ) 
			{
				torn_veil( true );
			}
		}
		else
		{
			if ( player_inside ) 
			{
				torn_veil( false );
			}
		}
		
		FindGameplayEntitiesInRange(entities_trap, this, 20, 100 );
		for ( i = 0; i <= entities_trap.Size(); i+=1 )
		{
			actor = (CActor)entities_trap[i];
			if ( !victims.Contains(actor) )
			{
				victims.PushBack(actor);
			}
			
			if (VecDistance( actor.GetWorldPosition(), this.GetWorldPosition() ) <= 4 )
			{
				if ( !actor.HasTag('spells_blocked_abs') )
				{
					actor.AddTag('spells_to_block_abs');
				}
			}
			else
			{
				if ( actor.HasTag('spells_blocked_abs') )
				{
					actor.AddTag('spells_to_unblock_abs');
				}
			}
		}
		block_abs();
	}
	
	function block_abs( optional force_disable : bool )
	{
		for ( i = 0; i <= victims.Size(); i+=1 )
		{
			if ( victims[i] != thePlayer )
			{
				if ( force_disable )
				{
					if ( victims[i].HasTag('spells_blocked_abs') )
					{
						for ( z = 0; z <= abs_to_block.Size(); z+=1 )
						{
							victims[i].BlockAbility(abs_to_block[z], false);
						}
						
						victims[i].RemoveTag('spells_blocked_abs');
						victims[i].RemoveTag('spells_to_unblock_abs');
						victims[i].RemoveTag('spells_to_block_abs');
						apply_slowdown( true, victims[i] );
					}
				}
				else
				{
					if ( victims[i].HasTag('spells_to_block_abs') )
					{
						for ( z = 0; z <= abs_to_block.Size(); z+=1 )
						{
							victims[i].BlockAbility(abs_to_block[z], true);
						}
						
						victims[i].AddTag('spells_blocked_abs');
						victims[i].RemoveTag('spells_to_block_abs');
						apply_slowdown( false, victims[i] );
					}
					
					if ( victims[i].HasTag('spells_to_unblock_abs')  )
					{
						for ( z = 0; z <= abs_to_block.Size(); z+=1 )
						{
							victims[i].BlockAbility(abs_to_block[z], false);
						}
						
						victims[i].RemoveTag('spells_blocked_abs');
						victims[i].RemoveTag('spells_to_unblock_abs');
						apply_slowdown( true, victims[i] );
					}
				}
			}
		}
	}
	
	function apply_slowdown( remove : bool, target : CActor )
	{
		var slow 	: SCustomEffectParams;	
	
		if ( !remove )
		{
			slow.effectType = EET_Slowdown;
			slow.creator = thePlayer;
			slow.sourceName = "spells_slowdown_veil";
			slow.duration = 99;
			
			//theGame.witcherLog.AddMessage("duration = " + get_spellpower_spells( false, S_Magic_3 ) * 4 );
			
			slow.customPowerStatValue = GetWitcherPlayer().GetTotalSignSpellPower(S_Magic_3);
			slow.effectValue.valueAdditive = 0.01 + (0.99 - 0.01) * slow.customPowerStatValue.valueMultiplicative / 5;
			slow.effectValue.valueAdditive = ClampF( slow.effectValue.valueAdditive, 0.01, 0.99 );				
			slow.customFXName = 'bla';
			target.AddEffectCustom(slow);
		}
		else
		{
			target.RemoveAllBuffsWithSource( "spells_slowdown_veil" );
		}
	}
	
	function torn_veil( value : bool )
	{
		if ( !value )
		{
			player_inside = false;
			GetMagicVigil().set_inside_veil(false);
			thePlayer.EnableCharacterCollisions(true);
			
			effect.StopAllEffects();
			
			//sword.StopAllEffects();
		}
		else
		{
			player_inside = true;
			SoundEvent("qu_nml_108_distance_wraith");
			GetMagicVigil().set_inside_veil(true);
			thePlayer.EnableCharacterCollisions(false);
			
			effect.PlayEffect('radial_blur');
			
			//if ( !GetMagicVigil().is_inside_energy )
			//{
				//sword.PlayEffectSingle('sword_veil');
			//}
		}
	}
}


statemachine class W3BloodVortex extends CGameplayEntity 
{	
	var i 																		: int;
	var victims 																: array< CActor >;
	var fxEntities                                                              : array< CEntity >;
	var spellpower_final														: float;
	var fire_hit_ents															: array< CEntity >;
	var damage_action 															: W3DamageAction;
	var ticket 																	: SMovementAdjustmentRequestTicket;
	var movementAdjustor														: CMovementAdjustor;
	var movingAgent																: CMovingAgentComponent;
	var damage_value															: float;
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		AddTimer('check_for_targets_blood_vortex', 0.1, true);
		PlayEffect('ignition');
		PlayEffect('ignition2');
		
		
		SoundEvent("monster_dettlaff_monster_combat_trap_trapped_whoosh");
		SoundEvent("monster_dettlaff_monster_combat_trap_LP");
		
		spellpower_final = 0;
	}
	
    timer function destroy_blood_vortex(deltaTime : float, id : int) 
	{
		StopAllEffects();
		DestroyEffect('ignition2');
		DestroyAfter(3);
		//AddTimer('destroy_light_effect',1.5 );
		RemoveTimer('check_for_targets_blood_vortex');
		
		SoundEvent("monster_dettlaff_monster_combat_trap_LP_stop");
		
		if ( fxEntities.Size() >0 )
		{
			for ( i = 0; i <= fxEntities.Size(); i+=1 )
			{
				fxEntities[i].StopAllEffects();
				fxEntities[i].DestroyAfter(2);
			}
		}
	}
    timer function destroy_light_effect(deltaTime : float, id : int) 
	{
		StopEffect('light');
	}
	
	event OnDestroyed()
	{
	}


	timer function check_for_targets_blood_vortex(deltaTime : float, id : int) 
	{
		var entities_trap		: array< CGameplayEntity >;
		var victim 				: CActor;
		var fxEntity			: CEntity;
		var actors				: array< CActor >;
		var actor				: CActor;
		
		if ( spellpower_final <=0 )
		{
			if ( HasTag('spells_from_sign') )
			{
				spellpower_final = GetMagicVigil().get_magic_spellpower();
			}
			else
			{
				spellpower_final = get_spellpower_spells( true );
			}
			
			//theGame.witcherLog.AddMessage("Sign SKILL  " + (string)GetMagicVigil().signskill );
			//theGame.witcherLog.AddMessage("Spellpower Final  " + GetMagicVigil().spellpower_final );
		}
		
		
		actors = GetWitcherPlayer().GetNPCsAndPlayersInRange( 20, 100, '', FLAG_Attitude_Hostile+FLAG_OnlyAliveActors );
		for( i = 0; i < actors.Size(); i += 1 )
		{	
			actor = (CActor)actors[i];
			movingAgent = actor.GetMovingAgentComponent();
			movementAdjustor = actor.GetMovingAgentComponent().GetMovementAdjustor();;
			ticket = movementAdjustor.CreateNewRequest( 'blood_devour');
			movementAdjustor.MaxRotationAdjustmentSpeed( ticket, 3 );
			movementAdjustor.MaxLocationAdjustmentSpeed( ticket, 3 );
			movementAdjustor.Continuous( ticket );
			movementAdjustor.KeepActiveFor( ticket, deltaTime );
			//movementAdjustor.SlideTo( ticket, this.GetWorldPosition() );
			movementAdjustor.SlideTowards( ticket, this );
			if( VecDistance( actor.GetWorldPosition(), this.GetWorldPosition() ) <= 1 ){	movementAdjustor.Cancel( ticket ); 	 }
			
			if( VecDistance( actor.GetWorldPosition(), this.GetWorldPosition() ) <= 15 )
			{
				if ( !victims.Contains( actor ) )
				{
					victims.PushBack( actor );
					fxEntity = actor.CreateFXEntityAtPelvis( 'bloodmoon_effects', true );
					fxEntity.PlayEffect( 'drain', this );
					fxEntities.PushBack(fxEntity);
				}
			}
			else
			{
				victims.Remove( actor );
			}
		}
		
		if ( fxEntities.Size() >0 )
		{
			for ( i = 0; i <= fxEntities.Size(); i+=1 )
			{
				if ( VecDistance( fxEntities[i].GetWorldPosition(), this.GetWorldPosition() ) > 15  )
				{
					fxEntities[i].StopAllEffects();
					fxEntities[i].DestroyAfter(3);
				}
				
				if ( VecDistance( fxEntities[i].GetWorldPosition(), this.GetWorldPosition() ) <= 5  )
				{
					fxEntities[i].PlayEffect( 'smoke' );
				}
				else
				{
					fxEntities[i].StopEffect( 'smoke' );
				}
			}
		}
		
		FindGameplayEntitiesInRange(entities_trap, this, 5, 100 );
		
		if( entities_trap.Size()>0 )
		{
			for ( i = 0; i <= entities_trap.Size(); i+=1 )
			{
				
				if ( VecDistance( entities_trap[i].GetWorldPosition(), this.GetWorldPosition() ) <= 3 )
				{
					victim = (CActor)entities_trap[i];
					if ( IsRequiredAttitudeBetween(thePlayer, victim, true, false, false)  )
					{
						damage_value = get_damage_value_for_special_trap( victim, spellpower_final );
						damage_value *= deltaTime;
						
						damage_action =  new W3DamageAction in this;
						damage_action.Initialize( thePlayer, victim, this, thePlayer.GetName()+"_sign", EHRT_None, CPS_Undefined, false, false, true, false);
						damage_action.SetIsDoTDamage( deltaTime );
						damage_action.AddDamage( theGame.params.DAMAGE_NAME_DIRECT, sp_direct_dmg_mod() * damage_value );
						damage_action.SetHitAnimationPlayType(EAHA_ForceNo);
						damage_action.SetProcessBuffsIfNoDamage(true);
						damage_action.SetHitEffect('');
						damage_action.SetHitEffect('', true );
						damage_action.SetHitEffect('', false, true);
						damage_action.SetHitEffect('', true, true);
						
						if ( spells_can_dismember( victim ) )
						{
							damage_action.SetForceExplosionDismemberment();
						}
						
						theGame.damageMgr.ProcessAction( damage_action );
						
						if ( ( (CNewNPC)victim ).IsShielded( thePlayer ) )
						{
							if ( ( (CNewNPC)victim ).GetBehaviorVariable( 'bShieldUp' ) == 0.f )
							{
								( (CNewNPC)victim ).SetBehaviorVariable( 'bShieldUp', 1.f );
							}
							
							if ( ( (CNewNPC)victim ).GetStaminaPercents() > 0.1 )
							{
								( (CNewNPC)victim ).DrainStamina(ESAT_FixedValue, 5 );
							}
							else 
							{
								( (CNewNPC)victim ).ProcessShieldDestruction();
							}
						}
						
						delete damage_action;
					}
				}
			}
		}
	}
}	


statemachine class W3AssassinTornado extends CGameplayEntity 
{	
	var i 																		: int;
	var victims 																: array< CActor >;
	var fxEntities                                                              : array< CEntity >;
	var spellpower_final														: float;
	var fire_hit_ents															: array< CEntity >;
	var damage_action 															: W3DamageAction;
	var ticket 																	: SMovementAdjustmentRequestTicket;
	var movementAdjustor														: CMovementAdjustor;
	var movingAgent																: CMovingAgentComponent;
	var damage_value															: float;
	var aard_hit_ents															: array< CEntity >;
	var tornado_target															: CActor;
	var tornado_move															: Vector;
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		AddTimer('check_for_targets_tornado', 0.01, true);
		AddTimer('tornado_clear_hits', 1.0f, true);
		PlayEffect('main');
		
		SoundEvent("magic_man_tornado_loop_start");
		
		spellpower_final = 0;
	}
	
	timer function tornado_clear_hits(deltaTime : float, id : int) 
	{
		aard_hit_ents.Clear();
	}
	
    timer function destroy_tornado(deltaTime : float, id : int) 
	{
		StopAllEffects();
		DestroyAfter(5);
		RemoveTimer('check_for_targets_tornado');
		RemoveTimer('tornado_clear_hits');
		
		SoundEvent("magic_man_tornado_loop_stop");
	}
	
	event OnDestroyed()
	{
	}


	timer function check_for_targets_tornado(deltaTime : float, id : int) 
	{
		var entities_trap		: array< CGameplayEntity >;
		var victim 				: CActor;
		var fxEntity			: CEntity;
		var actors				: array< CActor >;
		var actor				: CActor;
		
		if ( spellpower_final <=0 )
		{
			if ( HasTag('spells_from_sign') )
			{
				spellpower_final = GetMagicVigil().get_magic_spellpower();
			}
			else
			{
				spellpower_final = get_spellpower_spells( true );
			}
			
			//theGame.witcherLog.AddMessage("Sign SKILL  " + (string)GetMagicVigil().signskill );
			//theGame.witcherLog.AddMessage("Spellpower Final  " + GetMagicVigil().spellpower_final );
		}
		
		if ( !tornado_target.IsAlive() )
		{
			tornado_target = NULL;
			delete tornado_target;
		}
		
		if ( !tornado_target )
		{
			actors.Clear();
			actors = GetWitcherPlayer().GetNPCsAndPlayersInRange( 20, 100, '', FLAG_Attitude_Hostile+FLAG_OnlyAliveActors );
			if( actors.Size()>0 )
			{
				tornado_target = (CActor)actors[RandRange( actors.Size() )];
			}
		}
		
		//tornado_target.PlayEffectSingle('yrden_shock');
		
		if ( tornado_target )
		{
			tornado_move = this.GetWorldPosition() - VecFromHeading( AngleNormalize180( tornado_target.GetHeading()
													  - NodeToNodeAngleDistance( this, tornado_target) ) ) * 0.2 ;
		
			if( VecDistance( tornado_target.GetWorldPosition(), this.GetWorldPosition() )>0.5 )
			{	this.Teleport( TraceFloor( tornado_move ) );	 }
		}
		
		FindGameplayEntitiesInRange(entities_trap, this, 5, 100 );
		
		if( entities_trap.Size()>0 )
		{
			for ( i = 0; i <= entities_trap.Size(); i+=1 )
			{
				if ( !aard_hit_ents.Contains( entities_trap[i] ) && !entities_trap[i].HasTag('spells_custom_projs') )
				{
					entities_trap[i].OnAardHit( NULL );
					aard_hit_ents.PushBack( entities_trap[i] );
				}
				
				if ( VecDistance( entities_trap[i].GetWorldPosition(), this.GetWorldPosition() ) <= 3 )
				{
					victim = (CActor)entities_trap[i];
					if ( IsRequiredAttitudeBetween(thePlayer, victim, true, false, false)  )
					{
						damage_value = get_damage_value_for_special_trap( victim, spellpower_final );
						damage_value *= deltaTime;
						
						damage_action =  new W3DamageAction in this;
						damage_action.Initialize( thePlayer, victim, this, thePlayer.GetName()+"_sign", EHRT_None, CPS_Undefined, false, false, true, false);
						damage_action.SetIsDoTDamage( deltaTime );
						damage_action.AddDamage( theGame.params.DAMAGE_NAME_ELEMENTAL, sp_elem_dmg_mod() * damage_value );
						damage_action.SetHitAnimationPlayType(EAHA_ForceNo);
						damage_action.SetProcessBuffsIfNoDamage(true);
						
						damage_action.SetHitEffect('');
						damage_action.SetHitEffect('', true );
						damage_action.SetHitEffect('', false, true);
						damage_action.SetHitEffect('', true, true);
						
						if ( spells_can_dismember( victim ) )
						{
							damage_action.SetForceExplosionDismemberment();
						}
						
						theGame.damageMgr.ProcessAction( damage_action );
						
						if ( ( (CNewNPC)victim ).IsShielded( thePlayer ) )
						{
							if ( ( (CNewNPC)victim ).GetBehaviorVariable( 'bShieldUp' ) == 0.f )
							{
								( (CNewNPC)victim ).SetBehaviorVariable( 'bShieldUp', 1.f );
							}
							
							if ( ( (CNewNPC)victim ).GetStaminaPercents() > 0.1 )
							{
								( (CNewNPC)victim ).DrainStamina(ESAT_FixedValue, 5 );
							}
							else 
							{
								( (CNewNPC)victim ).ProcessShieldDestruction();
							}
						}
						
						delete damage_action;
					}
				}
			}
		}
	}
}	
